/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

public class PIDController {
    public double desiredpos;
    public float pfactor;
    public float ifactor;
    public float dfactor;
    public float scale;
    public float iaccum;
    public float ifade;
    public float maxspeed;
    public float minspeed;

    public PIDController(float sc, float p, float i, float ifd, float d, float mins, float maxs) {
        this.scale = sc;
        this.pfactor = p;
        this.ifactor = i;
        this.ifade = ifd;
        this.dfactor = d;
        this.iaccum = 0.0f;
        this.minspeed = mins;
        this.maxspeed = maxs;
    }

    public void setHoldpos(double pos) {
        this.desiredpos = pos;
        this.iaccum = 0.0f;
    }

    public float getAdjustment(double currentpos, float currentspeed) {
        float posdif = (float)(this.desiredpos - currentpos);
        float adjust = this.scale * this.pfactor * posdif;
        float reldist = 1.0f;
        this.iaccum += posdif;
        this.iaccum *= this.ifade;
        adjust += this.scale * this.ifactor * this.iaccum;
        if (posdif != 0.0f && (reldist = Math.abs(currentspeed / posdif)) > 1.0f) {
            reldist = 1.0f;
        }
        adjust -= this.scale * this.dfactor * currentspeed;
        if (currentspeed > this.maxspeed && adjust > 0.0f) {
            return 0.0f;
        }
        if (currentspeed < this.minspeed && adjust < 0.0f) {
            return 0.0f;
        }
        return adjust;
    }
}

